﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
// nestedEval.as
	// evalpath
	// getImpliedValue
	// resolveContainer

// run()
define_music = function( thisCommand_obj ){
	
	
	// temporarily max the volume to avoid volume glitch
	var vol = MUSIC.volume;
	var songVol = MUSIC.songVolume;
	MUSIC.songVolume = 100;
	MUSIC.volume = 100;
	// interrupt any current music fades
	MUSIC.fade.onMotionFinished();
	// play the song
	var fileName = nestedEval( thisCommand_obj.data.file, "RAM", "_this" );
	if(TRACE_SCRIPT)
		trace("music: "+fileName);
	MUSIC.playSong( fileName );
	// restore the overall volume
	MUSIC.volume = vol;
	// set the command's song volume
	MUSIC.songVolume = thisCommand_obj.data.volume;
	
	
	// instantly done
	return VOW.make().keep();
	
	
}// define_music()